const express = require('express');
const sqlite3 = require('sqlite3').verbose();
const app = express();
app.use(express.json());

// Initialize database
const db = new sqlite3.Database('./database.db', err => {
  if (err) console.error("Database connection error:", err);
  else initializeTables();
});

function initializeTables() {
  db.run(`CREATE TABLE IF NOT EXISTS jobcards (
      jobCardNumber INTEGER PRIMARY KEY AUTOINCREMENT,
      clientName TEXT,
      contactNumber TEXT,
      assignedEngineer TEXT,
      status TEXT DEFAULT 'New'
    )`);
}

// Create job card
app.post('/job-cards', (req, res) => {
  const { clientName, contactNumber, assignedEngineer } = req.body;
  db.run(`INSERT INTO jobcards (clientName, contactNumber, assignedEngineer) VALUES (?, ?, ?)`,
    [clientName, contactNumber, assignedEngineer], function(err) {
      if (err) res.status(500).json({ error: "Failed to create job card" });
      else res.json({ jobCardNumber: this.lastID });
    });
});

// Update engineer assignment
app.post('/jobcards/:jobCardNumber/assign', (req, res) => {
  const { jobCardNumber } = req.params;
  const { newEngineer } = req.body;
  db.run(`UPDATE jobcards SET assignedEngineer = ? WHERE jobCardNumber = ?`, [newEngineer, jobCardNumber], err => {
    if (err) res.status(500).json({ error: "Failed to update engineer assignment" });
    else res.json({ message: "Assignment updated" });
  });
});

// Update job status
app.post('/jobcards/:jobCardNumber/status', (req, res) => {
  const { jobCardNumber } = req.params;
  const { newStatus } = req.body;
  db.run(`UPDATE jobcards SET status = ? WHERE jobCardNumber = ?`, [newStatus, jobCardNumber], err => {
    if (err) res.status(500).json({ error: "Failed to update job status" });
    else res.json({ message: "Status updated" });
  });
});

// Notify customer
app.post('/jobcards/:jobCardNumber/notify', (req, res) => {
  // Placeholder for SMS/email notification code
  res.json({ message: "Customer notified" });
});

app.listen(3000, () => console.log('Server running on port 3000'));
